/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.overlays;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractStage;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.overlays.AbstractOverlay;
import pro.gravit.utils.helper.LogHelper;

public class ProcessingOverlay
extends AbstractOverlay {
    private Labeled description;

    public ProcessingOverlay(JavaFXApplication application) {
        super("overlay/processing/processing.fxml", application);
    }

    @Override
    public String getName() {
        return "processing";
    }

    @Override
    protected void doInit() {
        this.description = (Labeled)LookupHelper.lookup((Node)this.layout, "#description");
    }

    @Override
    public void reset() {
        this.description.textProperty().unbind();
        this.description.getStyleClass().remove((Object)"error");
        this.description.setText("...");
    }

    @Override
    public void errorHandle(Throwable e) {
        super.errorHandle(e);
        this.description.textProperty().unbind();
        this.description.getStyleClass().add((Object)"error");
        this.description.setText(e.toString());
    }

    public final <T extends WebSocketEvent> void processRequest(AbstractStage stage, String message, Request<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
        this.processRequest(stage, message, request, onSuccess, null, onError);
    }

    public final <T extends WebSocketEvent> void processRequest(AbstractStage stage, String message, Request<T> request, Consumer<T> onSuccess, Consumer<Throwable> onException, EventHandler<ActionEvent> onError) {
        try {
            ContextHelper.runInFxThreadStatic(() -> this.show(stage, (EventHandler<ActionEvent>)((EventHandler)e -> {
                try {
                    this.description.setText(message);
                    ((CompletableFuture)this.application.service.request(request).thenAccept(result -> {
                        LogHelper.dev((String)"RequestFuture complete normally");
                        onSuccess.accept(result);
                        ContextHelper.runInFxThreadStatic(() -> this.hide(0.0, null));
                    })).exceptionally(error -> {
                        if (onException != null) {
                            onException.accept((Throwable)error);
                        } else {
                            ContextHelper.runInFxThreadStatic(() -> this.errorHandle(error.getCause()));
                        }
                        ContextHelper.runInFxThreadStatic(() -> this.hide(2500.0, onError));
                        return null;
                    });
                }
                catch (IOException ex) {
                    this.errorHandle(ex);
                    this.hide(2500.0, onError);
                }
            })));
        }
        catch (Exception e) {
            ContextHelper.runInFxThreadStatic(() -> this.errorHandle(e));
        }
    }
}

